@props(['package'])
@push('style')
<style>
    .rating {
        display: flex;
    }

    .rating input[type="radio"] {
        display: none;
    }

    .rating label {
        font-size: 24px;
        color: gray;
        cursor: pointer;
        transition: color 0.3s;
    }
</style>
@endpush
@if ($package->reviews->count() > 0)
<div class="daily-review">
    <h3 class="destination-details-common-title">Reviews</h3>
    <p>Showing {{$package->reviews->count()}} review</p>
    @foreach ($package->reviews as $review)
    <div class="daily-review-box wow fadeInUp animated" data-wow-delay="100ms"
        style="visibility: visible; animation-delay: 100ms; animation-name: fadeInUp;">
        <div class="daily-review-image">
            <img src="{{asset($review->user->image)}}"
                alt="{{$review->user->name}}">
        </div>
        <div class="daily-review-info">
            <p>{{$review->created_at->format('D m, Y')}}</p>
            <h6>{{$review->user->name}}</h6>
            <div class="daily-review-rating">
                <ul>
                    @for ($i = 0; $i < 5; $i++) <li>
                    @if ($i < $review->rating)
                    <i class="fas fa-star text-warning"></i>
                    @else
                    <i class="far fa-star"></i>
                    @endif
                    </li>
                    @endfor
                </ul>
            </div>
            <p>
                {!!$review->content!!}
            </p>
        </div>
    </div>
    @endforeach
</div>
@endif


@auth
<div class="review-form wow fadeInUp add-review animated" data-wow-delay="100ms"
    style="visibility: visible; animation-delay: 100ms; animation-name: fadeInUp;">
    <h5>@lang('app.add-your-review')</h5>
    <form action="{{route('user.review.store')}}" method="post">
        @csrf
        <div class="row">
            <div class="col-12">
                @if ($errors->any())
                <div class="alert alert-danger">
                    <ul class="mb-0">
                        @foreach ($errors->all() as $error)
                        <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
                @endif
                @if (session('success'))
                <div class="alert alert-success">
                    {{ session('success') }}
                </div>
                @endif

                @if (session('error'))
                <div class="alert alert-danger">
                    {{ session('error') }}
                </div>
                @endif
            </div>
            <input type="hidden" name="package_id" value="{{$package->id}}">
            <div class="rating pt-2">
                <input type="radio" id="star5" name="rating" value="5">
                <label for="star5" title="5 stars"></label>
                <input type="radio" id="star4" name="rating" value="4">
                <label for="star4" title="4 stars"></label>
                <input type="radio" id="star3" name="rating" value="3">
                <label for="star3" title="3 stars"></label>
                <input type="radio" id="star2" name="rating" value="2">
                <label for="star2" title="2 stars"></label>
                <input type="radio" id="star1" name="rating" value="1">
                <label for="star1" title="1 star"></label>
            </div>
            <div class="col-lg-12">
                <textarea required name="content" class="review-input"
                    placeholder="@lang('app.write-your-review')"></textarea>
            </div>
            <div class="col-lg-12">
                <button type="submit" class="btn-1">@lang('app.review') <span></span></button>
            </div>
        </div>
    </form>
</div>
@endauth

@push('script')
<script>
    document.querySelectorAll('.rating input[type="radio"]').forEach(radio => {
            radio.addEventListener('change', function() {
                let stars = document.querySelectorAll('.rating label');
                stars.forEach(star => star.style.color = 'gray');

                let selectedValue = parseInt(this.value);
                stars.forEach((star, index) => {
                    if (index >= stars.length - selectedValue) {
                        star.style.color = 'gold';
                    }
                });
            });
        });

        $(document).ready(function () {
            $('.star-rating').each(function () {
                let rating = parseFloat($(this).data('rating'));
                let fullStars = Math.floor(rating);
                let halfStar = (rating % 1 !== 0);

                for (let i = 1; i <= fullStars; i++) {
                    $(this).append('<i class="fas fa-star"></i>');
                }

                if (halfStar) {
                    $(this).append('<i class="fas fa-star-half-alt half"></i>');
                }

                let unfilledStars = 5 - Math.ceil(rating);
                for (let j = 1; j <= unfilledStars; j++) {
                    $(this).append('<i class="far fa-star"></i>');
                }
            });
        });

</script>
@endpush
